-- new script file

local mdWave = {}
local mission = {}

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
		
		if not self.loaded then
			self.baseCount = 100 * Citadels.GetPlayer(0):GetDifficultyCoef()
			self.active = false
		end
  
		mission.enemy = Citadels.GetPlayer(1)
		self.mdAttSource:LinkToTarget("waveHandler")
		self.wayPoint1 = Game:GetEntity("monastery"):GetPosition()
    self.wayPoint2 = Game:GetEntity("castleBottom"):GetPosition()
    self.wayPoint3 = Game:GetEntity("castleSquare"):GetPosition()
    self.wayPoint4 = Game:GetEntity("castleMain"):GetPosition()
  end
  
  if self.active and not self.deactivated then
    InitializeWave(self)
    AttackWave(self)
		self.mdAttSource:TriggerAllTargets()
    self.active = false
  end  
end

function InitializeWave(self)
  mdWave['unit_L_archer_L2'] = self.baseCount * 0.4
  mdWave['unit_L_archer_L3'] = self.baseCount * 0.2
  mdWave['unit_L_fman_L2'] = self.baseCount * 0.35
  mdWave['unit_L_fman_L3'] = self.baseCount * 0.25
  mdWave['unit_L_rider_L2'] = self.baseCount * 0.3
  mdWave['unit_L_catapult_L2'] = self.baseCount * 0.1
end

function AttackWave(self)
  for prefab,ammount in pairs(mdWave) do
    mission.enemy:AttackGroupAdd(prefab, ammount)
  end
  mission.enemy:AttackGroupSetModeToSpawn() -- units will be spawned ( not trainded ) around rallypoint
  mission.enemy:AttackGroupAllowedTargetIndex(0) --attack only at player index 0 - human player
  mission.enemy:AttackGroupAddWayPoints(self.wayPoint1)
  mission.enemy:AttackGroupAddWayPoints(self.wayPoint2)
  mission.enemy:AttackGroupAddWayPoints(self.wayPoint3)
  mission.enemy:AttackGroupAddWayPoints(self.wayPoint4)
  mission.enemy:AttackGroupCommit(1, self.spawnPos, 20)
end


function OnTrigger(self, source, target)
  if target == "mdAtt" then
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
		CreateTriggerSources(self)
    self.loaded = true
		self.baseCount = ar:Read()
		self.active = ar:Read()
  elseif (ar:IsSaving()) then
		ar:Write(self.baseCount)
		ar:Write(self.active)
  end
end

function CreateTriggerTargets(self)
	self:AddTriggerTarget("mdAtt")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("mdAttSource")
end
